<?php
header('Content-type: text/html; charset=utf-8');
$template = '
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" class="inner"><head>

<title>'.$PRETITLE.' '.$lang['titleplayer'].' '.$player['name'].' :: '.$lang['titleplayerrang'].' - '.getRankByID($player['rank']).'</title>

<link rel="icon" href="'.$ROOT.'favicon.ico" type="image/x-icon" />
<link rel="shortcut icon" href="'.$ROOT.'favicon.ico" type="image/x-icon" />
<link rel="stylesheet" type="text/css" media="screen" href="'.$ROOT.'css/two-tiers.css" />
<link rel="stylesheet" type="text/css" media="screen" href="'.$ROOT.'css/inner.css">
<link rel="stylesheet" type="text/css" media="screen" href="'.$ROOT.'css/footer.css"/>
<link rel="stylesheet" type="text/css" media="screen" href="'.$ROOT.'css/nt.css" />
<link rel="stylesheet" type="text/css" media="print" href="'.$ROOT.'css/print.css" />

<script type="text/javascript">/* no frames */ if(top.location != self.location) top.location.replace(self.location);</script>
<script type="text/javascript" src="'.$ROOT.'js/nt2.js"></script>

<link rel="stylesheet" type="text/css" media="screen" href="'.$ROOT.'css/default.css">
<script src="'.$ROOT.'js/show.js" type="text/javascript"></script>
</head>
<body class="inner">

<div id="page-1">
	<div id="page-2">
	
	<h1 id="page-title"><img src="'.$ROOT.'images/game-images/ranks/header/rank_'.$player['rank'].'.png" alt="" />'.$player['name'].'<span class=zvanie>'.getRankByID($player['rank']).'</span></h1>

	<div id="page-3">
	
	<div id="content"><div id="content-id"><!-- template header end == begin content below -->
	
		<ul id="navitems">
			<li>|<a href="'.$ROOT.'">'.$lang['Home'].'</a>|</li>
            <li><a href="'.$ROOT.'forum.php">'.$lang['forum'].'</a>|</li>
            <li><a href="'.$ROOT.'?go=stats">'.$lang['top'].'</a>|</li>
            <li><a href="'.$ROOT.'?go=currentranking">'.$lang['Rankings'].'</a>|</li>
            <li><a href="'.$ROOT.'?go=lastrounds">'.$lang['lastrounds'].'</a>|</li>
            <li><a href="'.$ROOT.'?go=banlist">'.$lang['banlist'].'</a>|</li>
            <li><a href="'.$ROOT.'?go=monitor">'.$lang['monitor'].'</a>|</li>
			<li><a href="'.$ROOT.'?go=faq">'.$lang['FAQ'].'</a>|</li>
            <li><a href="'.$ROOT.'?go=ubar">'.$lang['UBAR'].'</a>|</li>
			<li><a href="http://wiki.bf2s.com/">'.$lang['Wiki'].'</a>|</li>
		</ul>
		
		<form action="'.$ROOT.'?go=search" method="post" id="getstats">
			<label for="pid">'.$lang['search'].':</label>
			<input type="text" name="searchvalue" id="pid" value="" />
			<input type="submit" class="btn" value="Go" />
		</form>
        
	<div id="prefCol">
	
		<div id="prefers">
			<img class="solider" src="';
			if (file_exists(getcwd().'images/game-images/soldiers/'.$playerSummary['army'].'_'.$playerSummary['kit'].'_'.$playerSummary['weapon'].'.jpg'))
				$template .= $ROOT.'images/game-images/soldiers/'.$playerSummary['army'].'_'.$playerSummary['kit'].'_'.$playerSummary['weapon'].'.jpg';
			else
				$template .= $ROOT.'images/game-images/soldiers/'.$playerSummary['army'].'_'.$playerSummary['kit'].'_5.jpg'; // show pistol...
			$template .= '" alt="'.$player['name'].' - '.getArmyByID($playerSummary['army']).'" />
			<img class="weapon" src="'.$ROOT.'images/game-images/weapons/weapon_'.$playerSummary['weapon'].'.jpg" alt="' . $weapons[$playerSummary['weapon']]['name'].'" />
			<img class="vehicle" src="'.$ROOT.'images/game-images/vehicles/vehicles_'.$playerSummary['vehicle'].'.jpg" alt="'.getVehicleByID($playerSummary['vehicle']).'" />
			<img class="kit" src="'.$ROOT.'images/game-images/kits/kit_'.$playerSummary['kit'].'.jpg" alt="'.getKitByID($playerSummary['kit']).'" />
			<img class="map" src="'.$ROOT.'images/game-images/maps/map_'.getFavouriteMap($PID).'.jpg" alt="'.getMapByID(getFavouriteMap($PID)).'" />
			<img id="flag" src="'.$ROOT.'images/game-images/flags/'.strtoupper($player['country']).'.png" alt="'.getCountryByCode($player['country']).'" width="32" height="24" />
		</div>
		
		<!--
		<p id="oostatus">
		<a id="add-to-mlb" href="'.$ROOT.'/?go=my-leaderboard&add='.$PID.'"><img src="'.$ROOT.'images/site-images/silk/user_add.png" alt="Add to My Leader Board" /></a>
		 . '.$player['name'].' is not online right now</p>
		-->
		
	</div>
	
	<table border="0" cellpadding="0" cellspacing="0" id="profile">

		<tr valign="top">
			<th>'.$lang['PlayerProfile'].'</th>
			<th>'.$lang['TeamProfile'].'</th>
			<th>'.$lang['CombatProfile'].'</th>
		</tr>
		<tr valign="top">
			<td><table border="0" cellpadding="0" cellspacing="0" id="player">

				<tr>
					<th colspan="2">'.$lang['Scores'].'</th>
					</tr>
				<tr>
					<td>'.$lang['Global'].'</td>
					<td>'.$player['score'].'</td>
					</tr>

				<tr>
					<td>'.$lang['Team'].'</td>
					<td>'.$player['teamscore'].'</td>
					</tr>
				<tr>
					<td>'.$lang['Combat'].'</td>
					<td>'.$player['skillscore'].'</td>

					</tr>
				<tr>
					<td>'.$lang['Commander'].'</td>
					<td>'.$player['cmdscore'].'</td>
					</tr>
					
				<tr>
					<th colspan="2">'.$lang['Time'].'</th>

					</tr>
				<tr>
					<td nowrap="nowrap">'.$lang['Parachute'].'</td>
					<td nowrap="nowrap">'.intToTime($vehicles[0]['timepara']).'</td>
					</tr>
				<tr>
					<td nowrap="nowrap">'.$lang['Commander'].'</td>

					<td nowrap="nowrap">'.intToTime($player['cmdtime']).'</td>
					</tr>
				<tr>
					<td nowrap="nowrap">'.$lang['SquadLeader'].'</td>
					<td nowrap="nowrap">'.intToTime($player['sqltime']).'</td>
					</tr>
				<tr>

					<td nowrap="nowrap">'.$lang['SquadMember'].'</td>
					<td nowrap="nowrap">'.intToTime($player['sqmtime']).'</td>
					</tr>
				<tr>
					<td nowrap="nowrap">'.$lang['LoneWolf'].'</td>
					<td nowrap="nowrap">'.intToTime($player['lwtime']).'</td>
					</tr>

					
				<tr>
					<td>'.$lang['Total'].':</td>
					<td nowrap="nowrap">'.intToTime($player['time']).'</td>
					</tr>
					
				</table></td>
			<td><table border="0" cellpadding="0" cellspacing="0" id="team">
					
				<tr>
					<td nowrap="nowrap">'.$lang['WinsLosses'].'</td>

					<td nowrap="nowrap">
			';
							$template .= $player['wins'] ."&nbsp;/&nbsp;" . $player['losses'].'&nbsp;(';
							if ($player['losses'])
								$template .= (sprintf("%2.2f", $player['wins']/$player['losses'])); 
							else
								$template .= $player['wins'];
							$template .= ')
					</td>
				</tr>
					
				<tr>
					<th colspan="2">'.$lang['CapturePoints'].'</th>
				</tr>

				<tr>
					<td nowrap="nowrap">'.$lang['CapturedCP'].'</td>
					<td>' . $player['captures'] . '</td>
				</tr>
				<tr>
					<td nowrap="nowrap">'.$lang['CaptureAssist'].'</td>
					<td>' . $player['captureassists'] . '</td>

				</tr>
				<tr>
					<td nowrap="nowrap">'.$lang['DefendedCP'].'</td>
					<td>' . $player['defends'] . '</td>
					</tr>
				<tr>
					<th colspan="2">'.$lang['Teamwork'].'</th>

				</tr>
				<tr>
					<td nowrap="nowrap">'.$lang['KillAssist'].'</td>
					<td>' . ($player['damageassists']+$player['passengerassists']+$player['targetassists']) . '</td>
				</tr>
				<tr>
					<td>'.$lang['Heal'].'</td>

					<td>' . $player['heals'] . '</td>
				</tr>
				<tr>
					<td>'.$lang['Revive'].'</td>
					<td>' . $player['revives'] . '</td>
				</tr>
				<tr>

					<td>'.$lang['Support'].'</td>
					<td>' . $player['ammos'] . '</td>
				</tr>
				<tr>
					<td>'.$lang['Repair'].'</td>
					<td>' . $player['repairs'] . '</td>
				</tr>

				<tr>
					<td>'.$lang['Driver'].' (ability+assist)</td>
					<td>'.$player['driverspecials'].'+'.$player['driverassists'].'</td>
				</tr>
				</table></td>
			<td><table border="0" cellpadding="0" cellspacing="0" id="combat">
				<tr>
					<td>'.$lang['Accuracy'].'</td>

					<td>' .  round($weaponSummary['average']['acc'],3) . '%</td>
				</tr>
				<tr>
					<td><acronym title="'.$lang['SPM2'].'">'.$lang['SPM'].'</acronym></td>
					<td>';
					if (intToMins($player['time']))
						$template .= round(($player['score']/intToMins($player['time'])),4);
					else
						$template .= $player['score'];
					$template .= '</td>
				</tr>
				<tr>

					<td>'.$lang['Suicides'].'</td>
					<td>' . $player['suicides'] . '</td>
				</tr>
				<tr>
					<td nowrap="nowrap">'.$lang['KDRatio'].'</td>
					<td>
					';
					
if ($player['deaths'])
	$template .= round($player['kills']/$player['deaths'],3);
else
	$template .= $player['kills'];
	
$template .= '
					</td>
				</tr>

				<tr>
					<th colspan="2">'.$lang['Kills'].'</th>
					</tr>
				<tr>
					<td nowrap="nowrap">'.$lang['TotalStreak'].'</td>
					<td>' . $player['kills'] . ' / ' . $player['killstreak'] . '</td>

					</tr>
				<tr>
					<td nowrap="nowrap">'.$lang['PerMinute'].'</td>
					<td>';
					if (intToMins($player['time'])) 
						$template .= round($player['kills'] / round(intToMins($player['time']),0), 3);
					else
						$template .= $player['kills'];
					$template .= '</td>
					</tr>
				<tr>
					<td nowrap="nowrap">'.$lang['PerRound'].'</td>

					<td>';
					
					if ($player['rounds']) 
						$template .= round($player['kills'] / $player['rounds'], 3);
					else
						$template .= round($player['kills']);
					$template .= '
					</td>
					</tr>
				<tr>
					<th colspan="2">'.$lang['Deaths'].'</th>
					</tr>
				<tr>
					<td>'.$lang['TotalStreak'].'</td>

					<td>';
					if ($player['deathstreak'])
						$template .= $player['deaths'].' / '.$player['deathstreak'];
					else
						$template .= $player['deaths'];
					$template .= '</td>
					</tr>
				<tr>
					<td>'.$lang['PerMinute'].'</td>
					<td>';
					if ($player['time'] )
						$template .= round($player['deaths'] / round(intToMins($player['time']),0), 3);
					else
						$template .= $player['deaths'];
					$template .=	'</td>
					</tr>
				<tr>

					<td>'.$lang['PerRound'].'</td>
					<td>';
					if ($player['rounds'])
						$template .= round($player['deaths'] / $player['rounds'], 3);
					else
						$template .= round($player['deaths']);
					$template .= '</td>
					</tr>
				</table></td>
		</tr>
	</table>
	
	
	<hr class="clear" />
		
	<em style="font-size: 9px; text-align: left; display: block;clear: both;padding-left: 8px;">'.$lang['info'].'</em>
	<div id="stats">
    <div class="col">
    
    <!-- Army open -->
	<table width=99% border="0" cellspacing="0" cellpadding="0" id="army" class="stat sortable">
		<tr>
			<th>'.$lang['Army'].'</th>
			<th>'.$lang['Time'].'</th>
			<th>'.$lang['Wins'].'</th>
			<th>'.$lang['Losses'].'</th>
			<th>'.$lang['Ratio'].'</th>
			<th>'.$lang['BestRound'].'</th>
		</tr>';

	for ($i=0; $i<getArmyCount(); $i++)
	{
		// if favourite add <tr class="favorite">
		if($playerSummary['army'] == $i) {$fav=" class=\"favorite\"";}
		else {$fav="";}
		$template .= '
			<tr'.$fav.'>
				<td id="army-'.$i.'"><img width=23 height=15 align="top" src="' . $ROOT . 'images/game-images/armies/'. $i .'.png"/> '.getArmyByID($i).'</td>
				<td nowrap="nowrap" title="'.$armies[0]['time'.$i].'">'.intToTime($armies[0]['time'.$i]).'</td>
				<td>'.$armies[0]['win'.$i].'</td>
	
				<td>'.$armies[0]['loss'.$i].'</td>
				<td>';
		if ($armies[0]['loss'.$i])
			$template .= round($armies[0]['win'.$i]/$armies[0]['loss'.$i],2);
		else
			$template .= $armies[0]['win'.$i];
		$template .= '</td>
				<td>'.$armies[0]["best$i"].'</td>
			</tr>
		';
	}

$template .= '		
		<tr class="totals sortbottom">			<td>'.$lang['Total'].'</td>
			<td nowrap="nowrap">' . intToTime($armySummary['total']['time']) . '</td>
			<td>' . $armySummary['total']['win'] . '</td>
			<td>' . $armySummary['total']['loss'] . '</td>
			<td> - </td>

			<td> - </td>
		</tr>
		<tr class="averages sortbottom">			<td>'.$lang['Averages'].'</td>
			<td nowrap="nowrap">' . intToTime($armySummary['average']['time']) . '</td>
			<td>' . round($armySummary['average']['win'],0) . '</td>
			<td>' . round($armySummary['average']['loss'],0) . '</td>
			<td>';
if ($armySummary['average']['loss'] > 0)
	$template .= round($armySummary['average']['win']/$armySummary['average']['loss'], 2);
else
	$template .= round($armySummary['average']['win'], 2);
	
$template .= '</td>

			<td>' . round($armySummary['average']['best'],0) . '</td>
		</tr>
	</table>
	<!-- Army Close -->
    
    <!-- Map Open -->
	<table width=99% border="0" cellspacing="0" cellpadding="0" id="map" class="stat sortable">
		<tr>
			<th>'.$lang['Map'].'</th>
			<th>'.$lang['Time'].'</th>
			<th>'.$lang['Wins'].'</th>
			<th>'.$lang['Losses'].'</th>
			<th>'.$lang['Ratio'].'</th>
			<th>'.$lang['BestRound'].'</th>
		</tr>';

		for ($i=0; $i<count($maps); $i++)
		{
        $map_data[$maps[$i]['mapid']]=$maps[$i]['time'];
			if (getFavouriteMap($PID) == $maps[$i]['mapid']) {$fav = " class=\"favorite\"";}
			else {$fav="";}
			$template .= '
			<tr'.$fav.'>
			<td id="map-'.$maps[$i]['mapid'].'">'.getMapByID($maps[$i]['mapid']).'</td>
				<td nowrap="nowrap" title="'.$maps[$i]['time'].'">'.intToTime($maps[$i]['time']).'</td>
				<td>'.$maps[$i]['win'].'</td>
				<td>'.$maps[$i]['loss'].'</td>
				<td>';
				if ($maps[$i]['loss'])
					$template .= round($maps[$i]['win']/$maps[$i]['loss'],2);
				else
					$template .= $maps[$i]['win'];
				$template .= '
				</td>
				<td>'.$maps[$i]['best'].'</td>
			</tr>';
		}
$template .= '
		<tr class="totals sortbottom">			<td>'.$lang['Total'].'</td>
			<td nowrap="nowrap">' . intToTime($mapSummary['total']['time']) . '</td>
			<td>' . $mapSummary['total']['win'] . '</td>
			<td>' . $mapSummary['total']['loss'] . '</td>
			<td> &ndash; </td>
			<td> &ndash; </td>
		</tr>
		<tr class="averages sortbottom">			<td>'.$lang['Averages'].'</td>
			<td nowrap="nowrap">' . intToTime($mapSummary['average']['time']) . '</td>
			<td>' . $mapSummary['average']['win'] . '</td>
			<td>' . $mapSummary['average']['loss'] . '</td>
			<td>' . $mapSummary['average']['ratio'] . '</td>
			<td>' . $mapSummary['average']['br'] . '</td>
		</tr>
	</table>
	<!-- Map Close -->
	
    <!-- Theater Open --><!--						 	
	<table width=99% border="0" cellspacing="0" cellpadding="0" id="map" class="stat sortable">
		<tr>
			<th>'.$lang['Theater'].'</th>
			<th>'.$lang['Time'].'</th>
			<th>'.$lang['Wins'].'</th>
			<th>'.$lang['Losses'].'</th>
			<th>'.$lang['Ratio'].'</th>
			<th>'.$lang['BestRound'].'</th>
		</tr>';
		
		#add <tr class="favorite">
		
		for ($i=0; $i<getArmyCount(); $i++)
		{
			$template .= '
			<tr>
				<td id="theater-'.$i.'">'.$TheaterData[$i]['name'].'</td>
				<td title="'.$TheaterData[$i]['time'].'" nowrap="nowrap">'.intToTime($TheaterData[$i]['time']).'</td>
				<td>'.$TheaterData[$i]['wins'].'</td>
				<td>'.$TheaterData[$i]['losses'].'</td>
				<td>'.round(getRatio($TheaterData[$i]['wins'], $TheaterData[$i]['losses']),2).'</td>
				<td>'.$TheaterData[$i]['br'].'</td>
			</tr>';
		}
		
		$template .= '
    </tbody></table>-->
	<!-- Theater Close -->
    
    <!-- Vehicle Open -->
    <table width=99% border="0" cellspacing="0" cellpadding="0" id="vehicle" class="stat sortable">
		<tr>
			<th>'.$lang['Vehicle'].'</th>
			<th>'.$lang['Time'].'</th>
			<th>'.$lang['Wins'].'</th>
			<th>'.$lang['Losses'].'</th>
			<th>'.$lang['RatioKD'].'</th>
			<th>'.$lang['RoadKills'].'</th>
		</tr>';
		
	for ($i=0; $i<getVehicleCount(); $i++)
	{
		if ($vehicles[0]['kills'.$i])
			$vehicleTotalKills=round((100*$vehicles[0]['kills'.$i]/$player['kills']),2);
		else
			$vehicleTotalKills=0;
		if($playerSummary['vehicle'] == $i) {$fav=" class=\"favorite\"";}
		else {$fav="";}
		$template .= '
			<tr'.$fav.'>
			<td id="vehicle-'.$i.'"><img width=15 height=15 align="top" src="' . $ROOT . 'images/game-images/vehicles/'. $i .'.png"/> '.getVehicleByID($i).'</td>
			<td nowrap="nowrap" title="'.$vehicles[0]['time'.$i].'">'.intToTime($vehicles[0]['time'.$i]).'</td>
			<td><span class="abbr" alt="'.$lang['Accountsfor'].' '.$vehicleTotalKills.'% '.$lang['ofallkills'].'">'.$vehicles[0]['kills'.$i].'</span></td>
			<td>'.$vehicles[0]['deaths'.$i].'</td>
			<td>';
			if ($vehicles[0]['deaths'.$i])
				$template .= round(($vehicles[0]['kills'.$i]+$vehicles[0]['rk'.$i])/$vehicles[0]['deaths'.$i],2);
			else 
				$template .= $vehicles[0]['kills'.$i];
			$template .= '</td>
			<td>'.$vehicles[0]['rk'.$i].'</td>
		</tr>
		';
	}
$template .= '
		<tr class="averages sortbottom">			<td>'.$lang['Total'].'</td>
			<td nowrap="nowrap">' . intToTime($vehicleSummary['total']['time']) . '</td>

			<td><span class="abbr" alt="'.$lang['Accountsfor'].'  
	';
					if ($vehicleSummary['total']['kills'])
						$template .= round((100*$vehicleSummary['total']['kills'])/$player['kills'],2);
					else
						$template .= 0;
		$template .= '% '.$lang['ofallkills'].'">' . $vehicleSummary['total']['kills'] . '</span></td>
			<td>' . $vehicleSummary['total']['deaths'] . '</td>
			<td> &ndash; </td>
			<td>' . $vehicleSummary['total']['rk'] . '</td>
		</tr>
		<tr class="totals sortbottom">			<td>'.$lang['Averages'].'</td>

			<td nowrap="nowrap">' . intToTime($vehicleSummary['average']['time']) . '</td>
			<td>' . round($vehicleSummary['average']['kills']) . '</td>
			<td>' . round($vehicleSummary['average']['deaths']) . '</td>
			<td>' . $vehicleSummary['average']['ratio'] . '</td>
			<td>' . round($vehicleSummary['average']['rk'],0) . '</td>
		</tr>
	</table>
	<!-- Vehicle Close -->
    
    <!-- Misc. Stats Open-->
	<table width=99% border="0" cellpadding="0" cellspacing="0" id="misc" class="stat">
		<tr>
			<th colspan="2">'.$lang['MiscStats'].'</th>

		</tr>
		<tr>
			<td>'.$lang['PlayerIDNumber'].'</td>
			<td nowrap="nowrap">' . $player['id'] . ' </td>
		</tr>
		<tr>
			<td>'.$lang['EnrollmentDate'].'</td>

			<td nowrap="nowrap">' . date('Y-m-d H:i:s', $player['joined']) . '</td>
		</tr>
		<tr>
			<td>'.$lang['LastBattleOn'].'</td>
			<td nowrap="nowrap">' . date('Y-m-d H:i:s', $player['lastonline']) . '</td>
		</tr>
		<tr>

			<td>'.$lang['LastUpdate'].'</td>
			<td nowrap="nowrap">{:LASTUPDATE:}</td>
		</tr>
		
		<tr>
			<td>'.$lang['NextUpdate'].'</td>
			<td nowrap="nowrap">{:NEXTUPDATE:}</td>
		</tr>
				
		<tr>
			<td>'.$lang['KickedBanned'].'</td>
			<td nowrap="nowrap">' . $player['kicked'] . ' / ' . $player['banned'] . '</td>
		</tr>
		
		<tr>
			<td>'.$lang['TeamKillsDamageVehicleDamage'].'</td>

			<td nowrap="nowrap">' . $player['teamkills'] . ' / ' . $player['teamdamage'] . ' / ' . $player['teamvehicledamage'] . '</td>
		</tr>
		
		<tr>
			<td>'.$lang['Comparison'].'</td>
			<td nowrap="nowrap">';
			$template .= '<a href="?go=currentranking&id=' . $player['id'] . '">'.$lang['Compare'].'</a></td>
		</tr>

		<tr>
			<td>'.$lang['PlayerHistory'].'</td>
			<td nowrap="nowrap">';
			$template .= '<a href="?go=playerhistory&pid=' . $player['id'] . '">'.$lang['LastRounds'].'</a></td>
		</tr>
	</table>
    <!-- Misc. Stats Close -->
    
	</div>
	<div class="col">
	
	<!-- Kit Open -->
    <table width=99% border="0" cellspacing="0" cellpadding="0" id="kit" class="stat sortable">
		<tr>
			<th>'.$lang['Kit'].'</th>
			<th>'.$lang['Time'].'</th>
			<th>'.$lang['Kills'].'</th>
			<th>'.$lang['Deaths'].'</th>
			<th>'.$lang['RatioKD'].'</th>
		</tr>';

	for ($i=0; $i<=getKitCount()-1; $i++)
	{
		# <tr class="favorite"> first line!
		if($playerSummary['kit'] == $i) {$fav=" class=\"favorite\"";}
		else {$fav="";}
		$template .= '
			<tr'.$fav.'>
			<td id="kit-'.$i.'"><img width=15 height=15 align="top" src="' . $ROOT . 'images/game-images/kits/'. $i .'.png"/> '.getKitByID($i).'</td>

			<td nowrap="nowrap" title="'.$kits[0]['time'.$i].'">'.intToTime($kits[0]['time'.$i]).'</td>
			<td><span class="abbr" alt="'.$lang['Accountsfor'].'  ';
			if ($player['kills'])
			{
				$template .= round((100*$kits[0]['kills'.$i])/$player['kills'],2);
			}
			else
				$template .= 0;
			$template .= '% '.$lang['ofallkills'].'">'.$kits[0]['kills'.$i].'</span></td>
			<td>'.$kits[0]['deaths'.$i].'</td>
			<td>';
			if ($kits[0]['deaths'.$i])
				$template .= round($kits[0]['kills'.$i]/$kits[0]['deaths'.$i],2);
			else
				$template .= $kits[0]['kills'.$i];
			$template .= '</td>
		</tr>';
	}
$template .= '

		<tr class="averages sortbottom">			<td>'.$lang['Total'].'</td>

			<td nowrap="nowrap">' . intToTime($kitSummary['total']['time']) . '</td>
			<td><span class="abbr" alt="'.$lang['Accountsfor'].'  ' . round($kitSummary['total']['totalkills'],2) . '% '.$lang['ofallkills'].'">' . $kitSummary['total']['kills'] . '</span></td>
			<td>' . $kitSummary['total']['deaths'] . '</td>
			<td> &ndash; </td>
		</tr>
		<tr class="totals sortbottom">			<td>'.$lang['Averages'].'</td>

			<td nowrap="nowrap">' . intToTime($kitSummary['average']['time']) . '</td>
			<td>' . round($kitSummary['average']['kills'],0) . '</td>
			<td>' . round($kitSummary['average']['deaths'],0) . '</td>
			<td>' . round($kitSummary['average']['ratio'],2) . '</td>
		</tr>
	</table>
	<!-- Kit Close -->
    
	<!-- Weapon Open -->
    <table width=99% border="0" cellspacing="0" cellpadding="0" id="weapon" class="stat sortable">

		<tr>
			<th>'.$lang['Weapon'].'</th>
			<th>'.$lang['Time'].'</th>
			<th>'.$lang['Kills'].'</th>
			<th>'.$lang['Deaths'].'</th>
			<th>'.$lang['RatioKD'].'</th>
			<th>'.$lang['Accuracy'].'</th>
		</tr>';
		// add  class="favorite" later
		for ($i=0; $i<=10;$i++)
		{
			#<tr class="favorite">
		if($playerSummary['weapon'] == $i) {$fav=" class=\"favorite\"";}
		else {$fav="";}
		$template .= '
			<tr'.$fav.'>
				<td id="weapon-'.$i.'">'.$weapons[$i]['name'].'</td>
				<td nowrap="nowrap" title="'.$weapons[$i]['time'].'">'.intToTime($weapons[$i]['time']).'</td>
				<td><span class="abbr" alt="'.$lang['Accountsfor'].'  '.round($weapons[$i]['totalkills'],2).'% '.$lang['ofallkills'].'">'.$weapons[$i]['kills'].'</span></td>
				<td>'.$weapons[$i]['deaths'].'</td>
	
				<td>';
				if ($weapons[$i]['deaths'])
					$template .=  round($weapons[$i]['kills']/$weapons[$i]['deaths'],2);
				else
					$template .=  $weapons[$i]['kills'];
				#calc shot hit Ratio
				if ($weapons[$i]['fired'] > 0)
				{
					$ratio = round(100*$weapons[$i]['hit']/$weapons[$i]['fired'],2);
					if ($ratio == 1) $ratio = 100;
				}
				else
					$ratio = 0;
				$template .=  '</td>
				<td title="'.$ratio.'"><span class="abbr" alt=" '.$lang['Shots'].': '.$weapons[$i]['fired'].',  '.$lang['Hits'].': '.$weapons[$i]['hit'].'">'.round($ratio, 2).'%</span></td>
			</tr>';	
		}		
$template .= '
		<tr>
			<td id="weapon-11">Explosives (C4, Claymore, AT Mine)</td>
			<td nowrap="nowrap" title="' . ($weapons[11]['time']+$weapons[13]['time']+$weapons[14]['time']) . '">' . intToTime($weapons[11]['time']+$weapons[13]['time']+$weapons[14]['time']) . '</td>';
		
			if ($weapons[11]['kills']+$weapons[13]['kills']+$weapons[14]['kills'])
				$ratio = round((100*$weapons[11]['kills']+$weapons[13]['kills']+$weapons[14]['kills'])/$player['kills'],2);
			else
				$ratio = 0;
				
			$template .= '<td><span class="abbr" alt="'.$lang['Accountsfor'].'  ';
			$template .= round($ratio,2);

			$template .=  '% '.$lang['ofallkills'].'">' . ($weapons[11]['kills']+$weapons[13]['kills']+$weapons[14]['kills']) . '</span></td>

			<td>' . ($weapons[11]['deaths']+$weapons[13]['deaths']+$weapons[14]['deaths']) . '</td>';
			// kd ratio
			if ($weapons[11]['deaths']+$weapons[13]['deaths']+$weapons[14]['deaths'])
				$ratio = ($weapons[11]['kills']+$weapons[13]['kills']+$weapons[14]['kills'])/($weapons[11]['deaths']+$weapons[13]['deaths']+$weapons[14]['deaths']);
			else
				$ratio =  $weapons[11]['kills']+$weapons[13]['kills']+$weapons[14]['kills'];
			$template .=   '<td>'.round($ratio,2);
			//kd fired/hit ratio
			if ($weapons[11]['fired']+$weapons[13]['fired']+$weapons[14]['fired'] > 0)
				$ratio = round(100*($weapons[11]['hit']+$weapons[13]['hit']+$weapons[14]['hit'])/($weapons[11]['fired']+$weapons[13]['fired']+$weapons[14]['fired']),2);
			else
				$ratio =  0;			
			$template .= '
				</td>
			<td title="' . $ratio . '"><span class="abbr" alt=" '.$lang['Shots'].': ' . ($weapons[11]['fired']+$weapons[13]['fired']+$weapons[14]['fired']) . ',  '.$lang['Hits'].': ' . ($weapons[11]['hit']+$weapons[13]['hit']+$weapons[14]['hit']) . '">' . round($ratio,2) . '%</span></td>
		</tr>
				<tr>
			<td id="weapon-12">' . $weapons[12]['name'] . '</td>
			<td nowrap="nowrap" title="' . $weapons[12]['time'] . '">' . intToTime($weapons[12]['time']) . '</td>

			<td><span class="abbr" alt="'.$lang['Accountsfor'].'  ' . round($weapons[12]['totalkills'],2) . '% '.$lang['ofallkills'].'">' . $weapons[12]['kills'] . '</span></td>
			<td>' . $weapons[12]['deaths'] . '</td>
			<td>';

			if ($weapons[12]['deaths'])
				$template .= round($weapons[12]['kills']/$weapons[12]['deaths'],2);
			else
				$template .= $weapons[12]['kills'];

			$template .= '</td>';

			if ($weapons[12]['hit'] > 0)
				$ratio = round(100*$weapons[12]['hit']/$weapons[12]['fired'],2);
			else
				$ratio = 0;
			$template .= '
			<td title="' . $ratio . '"><span class="abbr" alt=" '.$lang['Shots'].': ' . $weapons[12]['fired'] . ',  '.$lang['Hits'].': ' . $weapons[12]['hit'] . '">' . round($ratio,2) . '%</span></td>
		</tr>
				
		<tr class="totals sortbottom">			<td>'.$lang['Total'].'</td>

			<td nowrap="nowrap">' . intToTime($weaponSummary['total']['time']) . '</td>
			<td><span class="abbr" alt="'.$lang['Accountsfor'].'  ' . round($weaponSummary['total']['totalkills'],2) . '% '.$lang['ofallkills'].'">' . $weaponSummary['total']['kills'] . '</span></td>
			<td>' . $weaponSummary['total']['deaths'] . '</td>
			<td> &ndash; </td>
			<td> &ndash; </td>

		</tr>
		<tr class="averages sortbottom">			<td>'.$lang['Averages'].'</td>
			<td nowrap="nowrap">' . intToTime($weaponSummary['average']['time']) . '</td>
			<td>' . round($weaponSummary['average']['kills'],0) . '</td>
			<td>' . round($weaponSummary['average']['deaths'],0) . '</td>
			<td>' . round($weaponSummary['average']['ratio'],0) . '</td>

			<td><span class="abbr" alt=" '.$lang['Shots'].': ' . round($weaponSummary['average']['fired'],0) . ',  '.$lang['Hits'].': ' . round($weaponSummary['average']['hit'],0) . '">' . round($weaponSummary['average']['acc'],3) . '%</span></td>
		</tr>
	</table>
	<!-- Weapon Close -->
    
	<!-- Equipment Open -->
    <table width=99% border="0" cellspacing="0" cellpadding="0" id="equipment" class="stat sortable">
		<tr>
			<th>'.$lang['Equipment'].'</th>
			<th>'.$lang['Time'].'</th>
			<th>'.$lang['Kills'].'</th>
			<th>'.$lang['Deaths'].'</th>
			<th>'.$lang['RatioKD'].'</th>
			<th>'.$lang['Usage'].'</th>
		</tr>';
		#<!-- add  class="favorite" -->

		for ($i=9; $i<=17; $i++)
		{
		if($playerSummary['equip'] == $i) {$fav=" class=\"favorite\"";}
		else {$fav="";}
		$template .= '
			<tr'.$fav.'>
					<td nowrap="nowrap"><img width=15 height=15 align="top" src="' . $ROOT . 'images/game-images/equipment/'. $i .'.png"/> '.$weapons[$i]['name'].'</td>
					<td nowrap="nowrap" title="'. $weapons[$i]['time'] .'">'. intToTime($weapons[$i]['time']) .'</td>
					<td><span class="abbr" alt="'.$lang['Accountsfor'].'  '. round($weapons[$i]['totalkills'],2) .'% '.$lang['ofallkills'].'">'. $weapons[$i]['kills'] .'</span></td>
					<td>'. $weapons[$i]['deaths'] .'</td>
					<td>';
			if ($weapons[$i]['deaths'])
				$template .= round($weapons[$i]['kills']/$weapons[$i]['deaths'],2);
			else
				$template .= $weapons[$i]['kills'];	
			$template .= '
					</td>
					<td>'. $weapons[$i]['fired'].'</td>
				</tr>';
		}
		$template .= '
	
		<tr class="totals sortbottom">			<td>'.$lang['Total'].'</td>
			<td nowrap="nowrap">' . intToTime($equipmentSummary['total']['time']) . '</td>
			<td><span class="abbr" alt="'.$lang['Accountsfor'].'  ' . round($equipmentSummary['total']['totalkills'],2) . '% '.$lang['ofallkills'].'">' . $equipmentSummary['total']['kills'] . '</span></td>

			<td>' . $equipmentSummary['total']['deaths'] . '</td>
			<td>' . round($equipmentSummary['total']['ratio'],2) . '</td>
			<td>' . round($equipmentSummary['total']['fired'],0) . '</td>
		</tr>
		<tr class="averages sortbottom">			<td>'.$lang['Averages'].'</td>

			<td nowrap="nowrap">' . intToTime($equipmentSummary['average']['time']) . '</td>
			<td>' . round($equipmentSummary['average']['kills'],0) . '</td>
			<td>' . round($equipmentSummary['average']['deaths'],0) . '</td>
			<td>' . round($equipmentSummary['average']['ratio'],2) . '</td>
			<td>' . round($equipmentSummary['average']['fired'],0) . '</td>
		</tr>

	</table>
	<!-- Equipment Close -->
    
	<!-- Favorite Victims & Worst Enemies Open -->
    <table width=99% border="0" cellspacing="0" cellpadding="0" id="fov" class="stat">
	
		<tr>
			<th colspan="2">'.$lang['FavoriteVictimsWorstEnemies'].'</th>
		</tr>
		
		<tr>
			<td>'.$lang['FavoriteVictim'].'</td>';

			if ($victims && trim($victims[0]['victim']) != '')
			  $template .= '<td nowrap="nowrap"><acronym title="'.$lang['FavoriteRank'].' - '.getRankByID(getRankFromPID($victims[0]['victim'])).'"><img src="'.$ROOT.'images/game-images/ranks/icon/rank_'.getRankFromPID($victims[0]['victim']).'.gif"> <a rel="nofollow" href="?pid=' . $victims[0]['victim'] . '">' . getNickFromPID($victims[0]['victim']) . '</a></acronym> (' . $victims[0]['count'] . ')</td>';
			else
				$template .= '<td>'.$lang['FavoriteVictim2'].'</td>';
		$template .= '
		</tr>
		
		<tr>
			<td nowrap="nowrap">'.$lang['MoreVictims'].'</td>
			<td>';

			if (count($victims) < 10)
				$limit = count($victims)-1;
			else
				$limit = 9;
			$written = 0;
			for ($i=1; $i<=$limit; $i++)
			{
				if (trim($victims[$i]['victim']) != '' && $victims[$i]['count'] > 1) // minimum 2 kills
				{
					if ($written != 0) $template .=  ', ';
					$written++;
					$template .=  '<acronym title="'.$lang['FavoriteRank'].' - '.getRankByID(getRankFromPID($victims[$i]['victim'])).'"><img src="'.$ROOT.'images/game-images/ranks/icon/rank_'.getRankFromPID($victims[$i]['victim']).'.gif"> <a rel="nofollow" href="?pid='.$victims[$i]['victim'].'">'.getNickFromPID($victims[$i]['victim']).'</a></acronym> ('.$victims[$i]['count'].')';
				}
			}
$template .= '
		</td>	
		</tr>
		
		<tr>
			<td nowrap="nowrap">'.$lang['WorstEnemy'].'</td>
';
			if ($enemies)
				$template .=  '<td nowrap="nowrap"><acronym title="'.$lang['FavoriteRank'].' - '.getRankByID(getRankFromPID($enemies[0]['attacker'])).'"><img src="'.$ROOT.'images/game-images/ranks/icon/rank_'.getRankFromPID($enemies[0]['attacker']).'.gif"> <a rel="nofollow" href="?pid=' . $enemies[0]['attacker'] . '">' . getNickFromPID($enemies[0]['attacker']) . '</a></acronym> (' . $enemies[0]['count'] . ')</td>';
			else
				$template .=  '<td>'.$lang['WorstEnemy2'].'</td>';
$template .= '
		</tr>
		
		<tr>

			<td nowrap="nowrap">'.$lang['MoreEnemies'].'</td>
			<td>
';
			if (count($enemies) < 10)
				$limit = count($enemies)-1;
			else
				$limit = 9;			
			
			$written = 0;
			for ($i=1; $i<=$limit; $i++)
			{
				if ($enemies && trim($enemies[$i]['attacker']) != '' && $enemies[$i]['count'] > 1) // minimum 2 kills
				{
					if ($written != 0) $template .=  ', ';
					$written++;
					$template .=  '<acronym title="'.$lang['FavoriteRank'].' - '.getRankByID(getRankFromPID($enemies[$i]['attacker'])).'"><img src="'.$ROOT.'images/game-images/ranks/icon/rank_'.getRankFromPID($enemies[$i]['attacker']).'.gif"> <a rel="nofollow" href="?pid='.$enemies[$i]['attacker'].'">'.getNickFromPID($enemies[$i]['attacker']).'</a></acronym> ('.$enemies[$i]['count'].')';
				}
			}
$template .= '	
			</td>
		</tr>
	</table>
	<!-- Favorite Victims & Worst Enemies Open -->
    
    <!-- Expansion Open -->
    <table border="0" cellspacing="0" cellpadding="0" id="expansion" class="stat">
        <tr>
			<th>'.$lang['Expansion'].'</th>
			<th>'.$lang['bf2'].'</th>
			<th>'.$lang['bf2sf'].'</th>
			<th>'.$lang['bf2ef'].'</th>
			<th>'.$lang['bf2af'].'</th>
		</tr>
		<tr>
			<td>'.$lang['Time'].'</td>
			<td nowrap="nowrap" title="'.getExpasionTimeByName($PID, 'bf').'">'.intToTime(getExpasionTimeByName($PID, 'bf')).'</td>
			<td nowrap="nowrap" title="'.getExpasionTimeByName($PID, 'sf').'">'.intToTime(getExpasionTimeByName($PID, 'sf')).'</td>
			<td nowrap="nowrap" title="'.getExpasionTimeByName($PID, 'ef').'">'.intToTime(getExpasionTimeByName($PID, 'ef')).'</td>
			<td nowrap="nowrap" title="'.getExpasionTimeByName($PID, 'af').'">'.intToTime(getExpasionTimeByName($PID, 'af')).'</td>
		</tr>
	</table>
    <!-- Expansion Close -->
    
    </div>
	
	<hr class="clear" />
	
    <!-- Unlocks Open -->
	<table width=99% border="0" cellspacing="0" cellpadding="0" id="unlocks" class="basic-stat">
		<tr>
			<th>'.$lang['Unlocks'].'</th>
		</tr>
		<tr>
			<td>

';
				$unlockCount = getUnlockCount();
				for ($id=0; $id<$unlockCount; $id++)
				#foreach ($unlocks as $key => $value)
				{
					$uid = getUnlock($id); // eg 22, 33, 111 etc...
					#echo "$id=|$uid|";
					if (!isset($unlocks[$uid]['state'])) {$unlocks[$uid]['state'] = "n";}
				   $template .=  '
				   		<div class="unlock-inline" onmouseover="show_mine(this);" onmouseout="hide_mine(this);">
								<a target=_blank href="http://wiki.bf2s.com/weapons/unlocks/'.strtolower(getUnlockByID($id)).'/"><img src="'.$ROOT.'spacer.gif" style="background: url(\''.$ROOT.'images/game-images/unlocks/'.$unlocks[$uid]['state'].'/'.$uid.'.png\');" width="115" height="33" alt="" /></a>
								<div class="unlock-pop dir-left">
									<img src="'.$ROOT.'spacer.gif" style="background: url(\''.$ROOT.'images/game-images/unlocks/full/'.$uid.'.jpg\');" width="128" height="128" alt="" />
									<strong>'.$lang['UnlocksClick'].' '.getUnlockByID($id).'</strong>
								</div>
							</div>';
				}
$template .= '
			</td>
		</tr>
	</table>
	<!-- Unlocks Close -->
    
    <br />
	
	<!-- <br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /><br /> -->

	<!-- Awards Open -->
    <table width=99% border="0" cellspacing="0" cellpadding="0" id="awards" class="stat">
		
		<tr><th colspan="2">'.$lang['Awards'].'</th></tr>
				
		<tr><td>'.$lang['Badges'].'</td>
		<td class="awards-row">';

include("queries/db_awards.php");
include("queries/db_awardreqiretypes.php");
include("queries/db_awardrequirements.php");
include("queries/db_maps.php");

$count = getBadgeCount();
for ($i=0; $i<$count;$i++)
{
	$awardlevel = getBadgeLevel($PlayerAwards[$i]);

	$template .= '<div class="award-inline" onMouseOver="show_mine(this);" onMouseOut="hide_mine(this);">

		<img src="' . $ROOT . 'spacer.gif" style="background: url(\'' . $ROOT . 'images/game-images/awards/';
		if ($awardlevel>0)
			$template .= 'front/'.$PlayerAwards[$i][$awardlevel][AWD].'_'.$awardlevel;
		else
			$template .= 'locked/'.$PlayerAwards[$i][$awardlevel][AWD].'_0';

		$template .= '.png\');" width="42" height="42" alt="" align="center" />
		<div class="award-pop dir-';
		if ($i<$count/2)
			$template .= 'left';
		else
			$template .= 'right';

		$template .= '"><p><img src="'.$ROOT.'spacer.gif" style="background: url(\''.$ROOT.'images/game-images/awards/perspective/'.$PlayerAwards[$i][$awardlevel][AWD].'_'.$awardlevel.'.jpg\');" width="128" height="128" alt="" />

		<strong>'.$PlayerAwards[$i][$awardlevel][NAME].'</strong></p>';

  $a=0;$reqNumA=count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]]);
  while($a<$reqNumA)
    {$a+=1; $statshowed = 0;
	$b=0;$reqNumB=count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]);
$template .= '<ul>';
    if($a==1){$template .= '<li><font color="#B46A00"><strong>Basic</strong></font><i>'.earned($PlayerAwards[$i][1][EARNED]).'</i></li>';}
    elseif($a==2){$template .= '<li><font color="#B4B4B4"><strong>Veteran</strong></font><i>'.earned($PlayerAwards[$i][2][EARNED]).'</i></li>';}
    else{$template .= '<li><font color="#DED100"><strong>Expert</strong></font><i>'.earned($PlayerAwards[$i][3][EARNED]).'</i></li>';}

while($b<$reqNumB)
	  {$b+=1;
	  ## Р Р†РЎвЂ№Р Р†Р С•Р Т‘Р С‘Р С Р С‘Р Р…РЎвЂћР С•РЎР‚Р СР В°РЎвЂ Р С‘Р С•Р Р…Р Р…РЎвЂ№Р Вµ РЎРѓРЎвЂљРЎР‚Р С•Р С”Р С‘ РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘Р в„– Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
	  # Р ВµРЎРѓР В»Р С‘ РЎвЂљР С‘Р С— РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘РЎРЏ -- Р В·Р В° РЎР‚Р В°РЎС“Р Р…Р Т‘, РЎвЂљР ВµР С”РЎРѓРЎвЂљР С•Р Р†Р С”Р В°
	  #echo "/".key($award_requires[$award_id[$i]][$a])."/";
	  if(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])=="iar")
	    {$c=0; $template .= '<li><u>'.$lang['AwardsIAR'].'</u>';
		while($c<count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['iar']))
		  {$c+=1;$template .= '<li>'.$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['iar'][$c];}
		  # end of while C
		}
	  # Р ВµРЎРѓР В»Р С‘ РЎвЂљР С‘Р С— РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘РЎРЏ - Р Р…Р В°Р В»Р С‘РЎвЂЎР С‘Р Вµ Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
	  elseif(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])=="badge")
		{$c=0; $template .= '<li><u>'.$lang['Awards'].'</u>';
		while($c<count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge']))
			{$c+=1;$template .= '<li>';
			$template .= '- ';

$blt = "";
if ($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])] == 1) {$blt = "Basic ";}
if ($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])] == 2) {$blt = "Veteran ";}
if ($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])] == 3) {$blt = "Expert ";}
			if($awardlevel>=$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])])
				{$template .= $blt.''; $tmp = " <strong class=\"achieved\">&radic;</strong>";}else{$template .= $blt.''; $tmp = " <strong class=\"notachieved\">&times;</strong>";}
			$template .= $award[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])].' '.$requiretype[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])].$tmp;
			next($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge']);
			}
		}
	  # Р С‘Р Р…Р В°РЎвЂЎР Вµ, Р С•Р В±РЎвЂ№РЎвЂЎР Р…РЎвЂ№Р Вµ Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
      else
		{

$scorevalue = ValuetoID(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]));
		if (!$statshowed) {$template .= '<li><u>'.$lang['AwardsStats'].'</u><br />';$statshowed = 1;} $template .= '<li>';
		$template .= $requiretype[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])].':&nbsp;';
        $template .= pbar($scorevalue,$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])],substr(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]),0,4),$player['joined'],$player['lastonline']);
		} #end of else IAR
	  next($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]);
	  }
	  # end of while B

$template .= '</ul>';

    } # end of while a

		$template .= '</div></div>';

}

			$template .= '</tr>
		<tr><td>'.$lang['Medals'].'</td>
			<td class="awards-row extra-space">		';
$oldcount = $count;
$awdcount = getMedalCount();

$count = $oldcount+$awdcount;
for ($i=$oldcount; $i<$count;$i++)
{
$awardlevel = 0;
	$template .= '
		<div class="award-inline" onMouseOver="show_mine(this);" onMouseOut="hide_mine(this);">
		<img src="'.$ROOT.'spacer.gif" style="background: url(\''.$ROOT.'images/game-images/awards/';
		if ($PlayerAwards[$i][0][LEVEL]>0)
			$template .= 'front/'.$PlayerAwards[$i][0][AWD];
		else
			$template .= 'locked/'.$PlayerAwards[$i][0][AWD];
		
		$template .= '.png\');" width="42" height="42" alt="" /><div class="award-pop dir-';
		if ($i-$oldcount<$awdcount/2)
			$template .= 'left';
		else
			$template .= 'right';
		
		$template .= '"><p><img src="'.$ROOT.'spacer.gif" style="background: url(\''.$ROOT.'images/game-images/awards/perspective/'.$PlayerAwards[$i][0][AWD].'.jpg\');" width="128" height="128" alt="" />
		<strong>'.$PlayerAwards[$i][0][NAME].'</strong></p>';

  $a=0;$reqNumA=count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]]);
  while($a<$reqNumA)
    {$a+=1; $statshowed = 0; $nobr = 0;
	$b=0;$reqNumB=count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]);
$template .= '<ul>';
    //if($a==1){$template .= '<li><font color="#B46A00"><strong>Basic</strong></font><i>'.earned($PlayerAwards[$i][1][EARNED]).'</i></li>';}
    //elseif($a==2){$template .= '<li><font color="#B4B4B4"><strong>Veteran</strong></font><i>'.earned($PlayerAwards[$i][2][EARNED]).'</i></li>';}
    //else{$template .= '<li><font color="#DED100"><strong>Expert</strong></font><i>'.earned($PlayerAwards[$i][3][EARNED]).'</i></li>';}

while($b<$reqNumB)
	  {$b+=1;
	  ## Р Р†РЎвЂ№Р Р†Р С•Р Т‘Р С‘Р С Р С‘Р Р…РЎвЂћР С•РЎР‚Р СР В°РЎвЂ Р С‘Р С•Р Р…Р Р…РЎвЂ№Р Вµ РЎРѓРЎвЂљРЎР‚Р С•Р С”Р С‘ РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘Р в„– Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
	  # Р ВµРЎРѓР В»Р С‘ РЎвЂљР С‘Р С— РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘РЎРЏ -- Р В·Р В° РЎР‚Р В°РЎС“Р Р…Р Т‘, РЎвЂљР ВµР С”РЎРѓРЎвЂљР С•Р Р†Р С”Р В°
	  #echo "/".key($award_requires[$award_id[$i]][$a])."/";
	  if(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])=="iar")
	    {$c=0; $template .= '<li><u>'.$lang['AwardsIAR'].'</u>'; $nobr = 1;
		while($c<count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['iar']))
		  {$c+=1;$template .= '<li>'.$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['iar'][$c];}
		  # end of while C
		}
	  # Р ВµРЎРѓР В»Р С‘ РЎвЂљР С‘Р С— РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘РЎРЏ - Р Р…Р В°Р В»Р С‘РЎвЂЎР С‘Р Вµ Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
	  elseif(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])=="badge")
		{$c=0; if (!$dontshow) {$template .= '<li><u>'.$lang['Awards'].'</u><br />';}
		while($c<count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge']))
			{$c+=1; $template .= '<li>';
			$template .= '- ';

$blt = "";
if ($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])] == 1) {$blt = "Basic ";}
if ($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])] == 2) {$blt = "Veteran ";}
if ($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])] == 3) {$blt = "Expert ";}
$badgenomer = getCountBadge(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge']));
$awdlevel = getBadgeLevel($PlayerAwards[$badgenomer]);
			if($awdlevel>=$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])])
				{$template .= $blt.''; $tmp = " <strong class=\"achieved\">&radic;</strong>";}else{$template .= $blt.''; $tmp = " <strong class=\"notachieved\">&times;</strong>";}
			$template .= $award[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])].' '.$requiretype[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])].$tmp;
			next($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge']);
			}
		}
	  # Р ВµРЎРѓР В»Р С‘ РЎвЂљР С‘Р С— РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘РЎРЏ - Р Р…Р В°Р В»Р С‘РЎвЂЎР С‘Р Вµ Р СљР вЂўР вЂќР С’Р вЂєР В
	  elseif(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])=="medal")
		{$c=0; $template .= '<li><u>'.$lang['Awards'].'</u>'; $dontshow = 1;
		while($c<count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['medal']))
			{$c+=1;$template .= '<li>';
			$template .= '- ';

$blt = "";
$badgenomer = getCountMedal(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['medal']));
$awdlevel = getBadgeLevel($PlayerAwards[$badgenomer]);
			if($awdlevel>=$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['medal'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['medal'])])
				{$template .= $blt.''; $tmp = " <strong class=\"achieved\">&radic;</strong>";}else{$template .= $blt.''; $tmp = " <strong class=\"notachieved\">&times;</strong>";}
			$template .= $award[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['medal'])].' '.$requiretype[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])].$tmp;
			next($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['medal']);
			}
		}
	  # Р С‘Р Р…Р В°РЎвЂЎР Вµ, Р С•Р В±РЎвЂ№РЎвЂЎР Р…РЎвЂ№Р Вµ Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
      else
		{

$scorevalue = ValuetoID(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]));
		if (!$statshowed) {$template .= '<li><u>'.$lang['AwardsStats'].'</u><br />';$statshowed = 1;} $template .= '<li>';
		$template .= $requiretype[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])].':&nbsp;';
        $template .= pbar($scorevalue,$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])],substr(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]),0,4),$player['joined'],$player['lastonline']);
		} #end of else IAR
	  next($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]);
	  }
	  # end of while B
    } # end of while a

        $template .= '<br><br>';
		if (earned($PlayerAwards[$i][0][FIRST]) != '') {$template .= '<li>'.$lang['FirstReceived'].': '.earned($PlayerAwards[$i][0][FIRST]).'</li>';}
		if (earned($PlayerAwards[$i][0][EARNED]) != '') {$template .= '<li>'.$lang['LastAwarded'].': '.earned($PlayerAwards[$i][0][EARNED]).'</li>';}
		if ($PlayerAwards[$i][0][LEVEL] != 0) {$template .= '<li>'.$lang['TotalAwards'].': '.$PlayerAwards[$i][0][LEVEL].'</li>';}
        $template .= '</ul>';
		$template .= '</div></div>';
}

			$template .= '</tr>

		<tr><td>'.$lang['Ribbons'].'</td>
			<td class="awards-row extra-space">';
$oldcount = $count;
$awdcount = getRibbonCount();
$count = $oldcount+$awdcount;
for ($i=$oldcount; $i<$count;$i++)
{
$awardlevel = 0;
	$template .= '
		<div class="award-inline" onMouseOver="show_mine(this);" onMouseOut="hide_mine(this);">
		<img src="'.$ROOT.'spacer.gif" style="background: url(\''.$ROOT.'images/game-images/awards/';
		if ($PlayerAwards[$i][0][LEVEL]>0)
			$template .= 'front/'.$PlayerAwards[$i][0][AWD];
		else
			$template .= 'locked/'.$PlayerAwards[$i][0][AWD];
		
		$template .= '.png\');" width="42" height="42" alt="" />
		<div class="award-pop dir-';
		if ($i-$oldcount<$awdcount/2)
			$template .= 'left';
		else
			$template .= 'right';
		
		$template .= '"><p><img src="'.$ROOT.'spacer.gif" style="background: url(\''.$ROOT.'images/game-images/awards/perspective/'.$PlayerAwards[$i][0][AWD].'.jpg\');" width="128" height="128" alt="" />
		
		<strong>'.$PlayerAwards[$i][0][NAME].'</strong></p>';

  $a=0;$reqNumA=count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]]);
  while($a<$reqNumA)
    {$a+=1; $statshowed = 0; $nobr = 0;
	$b=0;$reqNumB=count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]);
$template .= '<ul>';

while($b<$reqNumB)
	  {$b+=1;
	  ## Р Р†РЎвЂ№Р Р†Р С•Р Т‘Р С‘Р С Р С‘Р Р…РЎвЂћР С•РЎР‚Р СР В°РЎвЂ Р С‘Р С•Р Р…Р Р…РЎвЂ№Р Вµ РЎРѓРЎвЂљРЎР‚Р С•Р С”Р С‘ РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘Р в„– Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
	  # Р ВµРЎРѓР В»Р С‘ РЎвЂљР С‘Р С— РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘РЎРЏ -- Р В·Р В° РЎР‚Р В°РЎС“Р Р…Р Т‘, РЎвЂљР ВµР С”РЎРѓРЎвЂљР С•Р Р†Р С”Р В°
	  #echo "/".key($award_requires[$award_id[$i]][$a])."/";
	  if(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])=="iar")
	    {$c=0; $template .= '<li><u>'.$lang['AwardsIAR'].'</u><br />'; $nobr = 1;
		while($c<count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['iar']))
		  {$c+=1;$template .= '<li>'.$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['iar'][$c];}
		  # end of while C
		}
	  # Р ВµРЎРѓР В»Р С‘ РЎвЂљР С‘Р С— РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘РЎРЏ - Р С”Р В°РЎР‚РЎвЂљР В°
	  elseif(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])=="map")
		{$c=0; if ($nobrdsfsdf) {$template .= '<br /><br />';} if (!$statshowed) {$template .= '<li><u>'.$lang['AwardsStats'].'</u><br />';$statshowed = 1;}
		while($c<count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['map']))
			{$c+=1;$template .= '<li>';
			$template .= $requiretype[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])].': ';
			if($map_data[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['map'])]>$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['map'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['map'])])
{ $tmp = " <strong class=\"achieved\">&radic;</strong>";}else{$tmp = " <strong class=\"notachieved\">&times;</strong>";}

			$template .= $mapname[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['map'])].$tmp;
			next($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['map']);
			;}
		}
	  # Р С‘Р Р…Р В°РЎвЂЎР Вµ, Р С•Р В±РЎвЂ№РЎвЂЎР Р…РЎвЂ№Р Вµ Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
      else
		{
$scorevalue = ValuetoID(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]));
		if ($nobrdsfsdf) {$template .= '<br /><br />';} if (!$statshowed) {$template .= '<li><u>'.$lang['AwardsStats'].'</u><br />';$statshowed = 1;} $template .= '<li>';
		$template .= $requiretype[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])].':&nbsp;';
        $template .= pbar($scorevalue,$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])],substr(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]),0,4),$player['joined'],$player['lastonline']);
		} #end of else IAR
	  next($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]);
	  }
	  # end of while B

    } # end of while a

        $template .= '<br><br>';
		if (earned($PlayerAwards[$i][0][EARNED]) != '') {
		$template .= '<li>'.$lang['FirstReceived'].': '.earned($PlayerAwards[$i][0][EARNED]).'</li>';
		}
        $template .= '</ul>';
		$template .= '</div></div>';
}
#################################################################################################
#SPECIAL FORCES AWARDS
#################################################################################################
#################################################################################################
# SF BADGES
#################################################################################################
			$template .= '
		
		<tr><td>'.$lang['SFBadges'].'</td>
		<td class="awards-row">';
		
include("queries/db_awards.php");
include("queries/db_awardreqiretypes.php");
include("queries/db_awardrequirements.php");
include("queries/db_maps.php");

$oldcount = $count;
$awdcount = getSFBadgeCount();
$count = $oldcount+$awdcount;
for ($i=$oldcount; $i<$count;$i++)
{
	$awardlevel = getBadgeLevel($PlayerAwards[$i]);

	$template .= '<div class="award-inline" onMouseOver="show_mine(this);" onMouseOut="hide_mine(this);">

		<img src="' . $ROOT . 'spacer.gif" style="background: url(\'' . $ROOT . 'images/game-images/awards/';
		if ($awardlevel>0)
			$template .= 'front/'.$PlayerAwards[$i][$awardlevel][AWD].'_'.$awardlevel;
		else
			$template .= 'locked/'.$PlayerAwards[$i][$awardlevel][AWD].'_0';

		$template .= '.png\');" width="42" height="42" alt="" />
		<div class="award-pop dir-';
		if ($i-$oldcount<$awdcount/1)
			$template .= 'left';
		else
			$template .= 'right';

		$template .= '"><p><img src="' . $ROOT . 'spacer.gif" style="background: url(\'' . $ROOT . 'images/game-images/awards/perspective/'.$PlayerAwards[$i][$awardlevel][AWD].'_'.$awardlevel.'.jpg\');" width="128" height="128" alt="" />

		<strong>'.$PlayerAwards[$i][$awardlevel][NAME].'</strong></p>';

  $a=0;$reqNumA=count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]]);
  while($a<$reqNumA)
    {$a+=1; $statshowed = 0;
	$b=0;$reqNumB=count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]);
$template .= '<ul>';
    if($a==1){$template .= '<li><font color="#B46A00"><strong>Basic</strong></font><i>'.earned($PlayerAwards[$i][1][EARNED]).'</i></li>';}
    elseif($a==2){$template .= '<li><font color="#B4B4B4"><strong>Veteran</strong></font><i>'.earned($PlayerAwards[$i][2][EARNED]).'</i></li>';}
    else{$template .= '<li><font color="#DED100"><strong>Expert</strong></font><i>'.earned($PlayerAwards[$i][3][EARNED]).'</i></li>';}

while($b<$reqNumB)
	  {$b+=1;
	  ## Р Р†РЎвЂ№Р Р†Р С•Р Т‘Р С‘Р С Р С‘Р Р…РЎвЂћР С•РЎР‚Р СР В°РЎвЂ Р С‘Р С•Р Р…Р Р…РЎвЂ№Р Вµ РЎРѓРЎвЂљРЎР‚Р С•Р С”Р С‘ РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘Р в„– Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
	  # Р ВµРЎРѓР В»Р С‘ РЎвЂљР С‘Р С— РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘РЎРЏ -- Р В·Р В° РЎР‚Р В°РЎС“Р Р…Р Т‘, РЎвЂљР ВµР С”РЎРѓРЎвЂљР С•Р Р†Р С”Р В°
	  #echo "/".key($award_requires[$award_id[$i]][$a])."/";
	  if(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])=="iar")
	    {$c=0; $template .= '<li><u>'.$lang['AwardsIAR'].'</u>';
		while($c<count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['iar']))
		  {$c+=1;$template .= '<li>'.$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['iar'][$c];}
		  # end of while C
		}
	  # Р ВµРЎРѓР В»Р С‘ РЎвЂљР С‘Р С— РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘РЎРЏ - Р Р…Р В°Р В»Р С‘РЎвЂЎР С‘Р Вµ Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
	  elseif(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])=="badge")
		{$c=0; $template .= '<li><u>'.$lang['Awards'].'</u>';
		while($c<count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge']))
			{$c+=1;$template .= '<li>';
			$template .= '- ';

$blt = "";
if ($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])] == 1) {$blt = "Basic ";}
if ($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])] == 2) {$blt = "Veteran ";}
if ($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])] == 3) {$blt = "Expert ";}
			if($awardlevel>=$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])])
				{$template .= $blt.''; $tmp = " <strong class=\"achieved\">&radic;</strong>";}else{$template .= $blt.''; $tmp = " <strong class=\"notachieved\">&times;</strong>";}
			$template .= $award[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])].' '.$requiretype[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])].$tmp;
			next($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge']);
			}
		}
	  # Р С‘Р Р…Р В°РЎвЂЎР Вµ, Р С•Р В±РЎвЂ№РЎвЂЎР Р…РЎвЂ№Р Вµ Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
      else
		{

$scorevalue = ValuetoID(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]));
		if (!$statshowed) {$template .= '<li><u>'.$lang['AwardsStats'].'</u><br />';$statshowed = 1;} $template .= '<li>';
		$template .= $requiretype[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])].':&nbsp;';
        $template .= pbar($scorevalue,$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])],substr(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]),0,4),$player['joined'],$player['lastonline']);
		} #end of else IAR
	  next($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]);
	  }
	  # end of while B

$template .= '</ul>';

    } # end of while a

		$template .= '</div></div>';

}
#################################################################################################
# SF MEDASLS
#################################################################################################
			$template .= '</tr>
		<tr><td>'.$lang['SFMedals'].'</td>
			<td class="awards-row extra-space">		';
$oldcount = $count;
$awdcount = getSFMedalCount();

$count = $oldcount+$awdcount;
for ($i=$oldcount; $i<$count;$i++)
{
$awardlevel = 0;
	$template .= '
		<div class="award-inline" onMouseOver="show_mine(this);" onMouseOut="hide_mine(this);">
		<img src="' . $ROOT . 'spacer.gif" style="background: url(\'' . $ROOT . 'images/game-images/awards/';
		if ($PlayerAwards[$i][0][LEVEL]>0)
			$template .= 'front/'.$PlayerAwards[$i][0][AWD];
		else
			$template .= 'locked/'.$PlayerAwards[$i][0][AWD];
		
		$template .= '.png\');" width="42" height="42" alt="" /><div class="award-pop dir-';
		if ($i-$oldcount<$awdcount/1)
			$template .= 'left';
		else
			$template .= 'right';
		
		$template .= '"><p><img src="' . $ROOT . 'spacer.gif" style="background: url(\'' . $ROOT . 'images/game-images/awards/perspective/'.$PlayerAwards[$i][0][AWD].'.jpg\');" width="128" height="128" alt="" />
		<strong>'.$PlayerAwards[$i][0][NAME].'</strong></p>';

  $a=0;$reqNumA=count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]]);
  while($a<$reqNumA)
    {$a+=1; $statshowed = 0; $nobr = 0;
	$b=0;$reqNumB=count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]);
$template .= '<ul>';

while($b<$reqNumB)
	  {$b+=1;
	  ## Р Р†РЎвЂ№Р Р†Р С•Р Т‘Р С‘Р С Р С‘Р Р…РЎвЂћР С•РЎР‚Р СР В°РЎвЂ Р С‘Р С•Р Р…Р Р…РЎвЂ№Р Вµ РЎРѓРЎвЂљРЎР‚Р С•Р С”Р С‘ РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘Р в„– Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
	  # Р ВµРЎРѓР В»Р С‘ РЎвЂљР С‘Р С— РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘РЎРЏ -- Р В·Р В° РЎР‚Р В°РЎС“Р Р…Р Т‘, РЎвЂљР ВµР С”РЎРѓРЎвЂљР С•Р Р†Р С”Р В°
	  #echo "/".key($award_requires[$award_id[$i]][$a])."/";
	  if(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])=="iar")
	    {$c=0; $template .= '<li><u>'.$lang['AwardsIAR'].'</u>'; $nobr = 1;
		while($c<count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['iar']))
		  {$c+=1;$template .= '<li>'.$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['iar'][$c];}
		  # end of while C
		}
	  # Р ВµРЎРѓР В»Р С‘ РЎвЂљР С‘Р С— РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘РЎРЏ - Р Р…Р В°Р В»Р С‘РЎвЂЎР С‘Р Вµ Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
	  elseif(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])=="badge")
		{$c=0; if (!$dontshow) {$template .= '<li><u>'.$lang['Awards'].'</u><br />';}
		while($c<count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge']))
			{$c+=1; $template .= '<li>';
			$template .= '- ';

$blt = "";
if ($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])] == 1) {$blt = "Basic ";}
if ($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])] == 2) {$blt = "Veteran ";}
if ($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])] == 3) {$blt = "Expert ";}
$badgenomer = getCountBadge(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge']));
$awdlevel = getBadgeLevel($PlayerAwards[$badgenomer]);
			if($awdlevel>=$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])])
				{$template .= $blt.''; $tmp = " <strong class=\"achieved\">&radic;</strong>";}else{$template .= $blt.''; $tmp = " <strong class=\"notachieved\">&times;</strong>";}
			$template .= $award[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge'])].' '.$requiretype[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])].$tmp;
			next($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['badge']);
			}
		}
	  # Р ВµРЎРѓР В»Р С‘ РЎвЂљР С‘Р С— РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘РЎРЏ - Р Р…Р В°Р В»Р С‘РЎвЂЎР С‘Р Вµ Р СљР вЂўР вЂќР С’Р вЂєР В
	  elseif(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])=="medal")
		{$c=0; $template .= '<li><u>'.$lang['Awards'].'</u>'; $dontshow = 1;
		while($c<count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['medal']))
			{$c+=1;$template .= '<li>';
			$template .= '- ';

$blt = "";
$badgenomer = getCountMedal(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['medal']));
$awdlevel = getBadgeLevel($PlayerAwards[$badgenomer]);
			if($awdlevel>=$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['medal'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['medal'])])
				{$template .= $blt.''; $tmp = " <strong class=\"achieved\">&radic;</strong>";}else{$template .= $blt.''; $tmp = " <strong class=\"notachieved\">&times;</strong>";}
			$template .= $award[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['medal'])].' '.$requiretype[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])].$tmp;
			next($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['medal']);
			}
		}
	  # Р С‘Р Р…Р В°РЎвЂЎР Вµ, Р С•Р В±РЎвЂ№РЎвЂЎР Р…РЎвЂ№Р Вµ Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
      else
		{

$scorevalue = ValuetoID(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]));
		if (!$statshowed) {$template .= '<li><u>'.$lang['AwardsStats'].'</u><br />';$statshowed = 1;} $template .= '<li>';
		$template .= $requiretype[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])].':&nbsp;';
        $template .= pbar($scorevalue,$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])],substr(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]),0,4),$player['joined'],$player['lastonline']);
		} #end of else IAR
	  next($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]);
	  }
	  # end of while B
    } # end of while a

        $template .= '<br><br>';
		if (earned($PlayerAwards[$i][0][FIRST]) != '') {$template .= '<li>'.$lang['FirstReceived'].': '.earned($PlayerAwards[$i][0][FIRST]).'</li>';}
		if (earned($PlayerAwards[$i][0][EARNED]) != '') {$template .= '<li>'.$lang['LastAwarded'].': '.earned($PlayerAwards[$i][0][EARNED]).'</li>';}
		if ($PlayerAwards[$i][0][LEVEL] != 0) {$template .= '<li>'.$lang['TotalAwards'].': '.$PlayerAwards[$i][0][LEVEL].'</li>';}
        $template .= '</ul>';
		$template .= '</div></div>';
}
#################################################################################################
# SF RIBBONS
#################################################################################################
			$template .= '</tr>		
		<tr><td>'.$lang['SFRibbons'].'</td>
			<td class="awards-row extra-space">';
$oldcount = $count;
$awdcount = getSFRibbonCount();
$count = $oldcount+$awdcount;
for ($i=$oldcount; $i<$count;$i++)
{
$awardlevel = 0;
	$template .= '
		<div class="award-inline" onMouseOver="show_mine(this);" onMouseOut="hide_mine(this);">
		<img src="'.$ROOT.'spacer.gif" style="background: url(\''.$ROOT.'images/game-images/awards/';
		if ($PlayerAwards[$i][0][LEVEL]>0)
			$template .= 'front/'.$PlayerAwards[$i][0][AWD];
		else
			$template .= 'locked/'.$PlayerAwards[$i][0][AWD];
		
		$template .= '.png\');" width="42" height="42" alt="" />
		<div class="award-pop dir-';
		if ($i-$oldcount<$awdcount/1)
			$template .= 'left';
		else
			$template .= 'right';
		
		$template .= '"><p><img src="'.$ROOT.'spacer.gif" style="background: url(\''.$ROOT.'images/game-images/awards/perspective/'.$PlayerAwards[$i][0][AWD].'.jpg\');" width="128" height="128" alt="" />
		
		<strong>'.$PlayerAwards[$i][0][NAME].'</strong></p>';

  $a=0;$reqNumA=count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]]);
  while($a<$reqNumA)
    {$a+=1; $statshowed = 0; $nobr = 0;
	$b=0;$reqNumB=count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]);
$template .= '<ul>';

while($b<$reqNumB)
	  {$b+=1;
	  ## Р Р†РЎвЂ№Р Р†Р С•Р Т‘Р С‘Р С Р С‘Р Р…РЎвЂћР С•РЎР‚Р СР В°РЎвЂ Р С‘Р С•Р Р…Р Р…РЎвЂ№Р Вµ РЎРѓРЎвЂљРЎР‚Р С•Р С”Р С‘ РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘Р в„– Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
	  # Р ВµРЎРѓР В»Р С‘ РЎвЂљР С‘Р С— РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘РЎРЏ -- Р В·Р В° РЎР‚Р В°РЎС“Р Р…Р Т‘, РЎвЂљР ВµР С”РЎРѓРЎвЂљР С•Р Р†Р С”Р В°
	  #echo "/".key($award_requires[$award_id[$i]][$a])."/";
	  if(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])=="iar")
	    {$c=0; $template .= '<li><u>'.$lang['AwardsIAR'].'</u><br />'; $nobr = 1;
		while($c<count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['iar']))
		  {$c+=1;$template .= '<li>'.$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['iar'][$c];}
		  # end of while C
		}
	  # Р ВµРЎРѓР В»Р С‘ РЎвЂљР С‘Р С— РЎвЂљРЎР‚Р ВµР В±Р С•Р Р†Р В°Р Р…Р С‘РЎРЏ - Р С”Р В°РЎР‚РЎвЂљР В°
	  elseif(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])=="map")
		{$c=0; if ($nobrdsfsdf) {$template .= '<br /><br />';} if (!$statshowed) {$template .= '<li><u>'.$lang['AwardsStats'].'</u><br />';$statshowed = 1;}
		while($c<count($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['map']))
			{$c+=1;$template .= '<li>';
			$template .= $requiretype[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])].': ';
			if($map_data[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['map'])]>$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['map'][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['map'])])
{ $tmp = " <strong class=\"achieved\">&radic;</strong>";}else{$tmp = " <strong class=\"notachieved\">&times;</strong>";}

			$template .= $mapname[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['map'])].$tmp;
			next($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]['map']);
			;}
		}
	  # Р С‘Р Р…Р В°РЎвЂЎР Вµ, Р С•Р В±РЎвЂ№РЎвЂЎР Р…РЎвЂ№Р Вµ Р Р…Р В°Р С–РЎР‚Р В°Р Т‘РЎвЂ№
      else
		{
$scorevalue = ValuetoID(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]));
		if ($nobrdsfsdf) {$template .= '<br /><br />';} if (!$statshowed) {$template .= '<li><u>'.$lang['AwardsStats'].'</u><br />';$statshowed = 1;} $template .= '<li>';
		$template .= $requiretype[key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])].':&nbsp;';
        $template .= pbar($scorevalue,$award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a][key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a])],substr(key($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]),0,4),$player['joined'],$player['lastonline']);
		} #end of else IAR
	  next($award_requires[$PlayerAwards[$i][$awardlevel][AWD]][$a]);
	  }
	  # end of while B

    } # end of while a

        $template .= '<br><br>';
		if (earned($PlayerAwards[$i][0][EARNED]) != '') {
		$template .= '<li>'.$lang['FirstReceived'].': '.earned($PlayerAwards[$i][0][EARNED]).'</li>';
		}
        $template .= '</ul>';
		$template .= '</div></div>';
}
			$template .= '</tr>						
	</table>

	
    <table width=99% border="0" cellspacing="0" cellpadding="0" id="tta" class="stat">
		<tr>
			<th colspan="2">'.$lang['TimeToAdvancement'].'</th>
		</tr>
		<tr>
			<td>'.$lang['Rank'].'</td>

			<td>';
				if (!$noranks) {$template .= '<img src="'.$ROOT.'images/game-images/ranks/progress/rank_'.$nextrank.'.png" alt="" style="float: left; margin: 0 5px 5px 0" height="83" width="83" />
				<p>
					<strong>'.$lang['NextRank'].': '.$newrank.'</strong>';
                    if ($noteligible) {$template .= '<small>'.$lang_test.'</small>';}

									$template .= '</p>
				
				<div class="progressbar">
					<div class="progress" style="width: '.$pcntDiff.'%"><span> '.$pcntDiff.'%</span></div>
				</div>

				<small>'.$lang['test2'].'</small>';}
                else $template .= '<strong>' .$newrank . '</strong>';

$template .='<div class="clear"> </div>
			</td>
		</tr>
	</table>
    

<a id="secondhome" href="'.$ROOT.'"> </a>
	<!-- end content == footer below -->
	
	<hr class="clear" />
	</div>
    

	</div> <!-- content-id --><!-- content -->
       
</div>
<div id="footer"><!-- footer -->
<div class="footer_mod">
    <div class="footer_mod_left"><!-- Language -->
        <form method="post" id="content">
            '.$lang['select'].'
            <select name="lang">
            <option value="ru">Russian</option>
            <option value="en">English</option>
            <option value="jp">Japanese</option>
            </select>
            <input type="submit" value="'.$lang['selectsave'].'" />
        </form>
    </div><!-- / Language -->
    <div class="footer_mod_right">
    <a href="#top">'.$UpPage.'</a><br/>
    <!--&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp<br/>&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp-->
    </div>
    <div class="footer_mod_center">'.$lang['footerLASTUPDATE'].'. '.$lang['footerNEXTUPDATE'].'.<br>
	'.$lang['footerPROCESSED'].'.<br><br/>
    '.$lang['copyrightProject'].'<br/>
    <!-- Уважайте мою работу - не трогайте нижнюю строчку... (^ω^)/ -->
    '.$lang['copyrightBF2REW'].'<br/>
    '.$lang['copyrightJobProject'].'<br/></div>
</div>
</div><!-- footer -->';
$template .= '</body></html>';
?>